package w83b.w83bOperacionesInternas.w83bIncidencias;


import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import org.apache.commons.lang.StringUtils;

import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bNuevaIncidenciasBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
/**
 * 
 * @author 
 *
 */
public class W83bModificarIncidenciasAction extends Q70OperacionInterna{
	/**
	 * preProcessMappingEntrada
	 * @param contexto a
	 * @param configBean a
	 * @param errors a
	 * @throws Exception e
	 */				
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean configBean, Q70OperacionInternaErrors errors) throws Exception{
		W83bNuevaIncidenciasBean incidenciasBean = (W83bNuevaIncidenciasBean)contexto.get("w83bNuevaIncidenciasBean");
		if (contexto.get("w83bMapaFileIncidencias")!=null)
		{

			HashMap mapaFiles =(HashMap)contexto.get("w83bMapaFileIncidencias");
			Iterator iter = mapaFiles.keySet().iterator();
			W83bDocBean docBean=null;
			while (iter.hasNext())
			{
				HashMap datosFile=(HashMap)mapaFiles.get(iter.next());
				docBean= new W83bDocBean();//NOPMD
				docBean.setCodFase(((String)datosFile.get("tipodocumento")).split("_")[1]);
				docBean.setCodTramite(((String)datosFile.get("tipodocumento")).split("_")[2]);
				docBean.setNombre((String)datosFile.get("nombreDocumento"));
				docBean.setTipoDocumento(((String)datosFile.get("tipodocumento")).split("_")[0]);
				docBean.setFechaRegistro((String)datosFile.get("fecharegistro"));
				docBean.setUsuario((String)datosFile.get("usuario"));
				docBean.setNumeroRegistro((String)datosFile.get("numregistro"));
				docBean.setFileData((InputStream)datosFile.get("documentoStream"));
				docBean.setTamanyo(((Long)datosFile.get("tamanyo")).intValue());
				incidenciasBean.getListaDocs().add(docBean);

			}
		}
		if (contexto.get("w83bListaBorradoFileIncidencias")!=null)
		{

			ArrayList listaBorrados =(ArrayList)contexto.get("w83bListaBorradoFileIncidencias");
			incidenciasBean.setListaDocsBorrados(listaBorrados);
			if(StringUtils.isEmpty(incidenciasBean.getCodSelec())){
				HashMap w83bMapaIncidencias = (HashMap)contexto.get("w83bMapaIncidencias");
				incidenciasBean.setCodSelec((String)w83bMapaIncidencias.get("codSelec"));

			}
		}
		
		contexto.set("w83bNuevaIncidenciasBean",incidenciasBean);
				
		super.preProcessMappingEntrada(contexto, configBean, errors);
			
	}
	/**
	 * postProcessMappingSalida
	 * @param contexto a
	 * @param errors a
	 * @throws Exception e
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {

		
		String resultado = (String)contexto.get("w83bResultado");
		
		boolean errorLibroRegistro = resultado.indexOf("-3") != -1;
		
		if(errorLibroRegistro){
			W83bUtilidadesComunes.anyadirMensajeErrorAplicacion(errors, "error.mensaje.edicionIncidenciasOkDocuMal", (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));			
		}else{
			contexto.set(W83bClsConstantes.CONSTANTE_MENSAJES_APLICACION_NO_ERROR, "comun.mensaje.bdActualizadaOk");
			contexto.set("guardado","true");			
		}
		
		super.postProcessMappingSalida(contexto, errors);
	}
	
}
